/*
    Copyright (c) 2002, bDistributed.com, Inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or
    without modification, are permitted provided that the following
    conditions are met:

    *   Redistributions of source code must retain the above
        copyright notice, this list of conditions and the following
        disclaimer.
    
    *   Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials
        provided with the distribution.
    
    *   Neither the name of bDistributed.com, Inc. nor the names of
        its contributors may be used to endorse or promote products
        derived from this software without specific prior written
        permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
    CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
    OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
    OF SUCH DAMAGE.
*/

#import <Foundation/Foundation.h>


#define BDQualifierOperatorEqual		@selector(isEqualTo:)
#define BDQualifierOperatorNotEqual		@selector(isNotEqualTo:)
#define BDQualifierOperatorLessThan		@selector(isLessThan:)
#define BDQualifierOperatorGreaterThan		@selector(isGreaterThan:)
#define BDQualifierOperatorLessThanOrEqualTo	@selector(isLessThanOrEqualTo:)
#define BDQualifierOperatorGreaterThanOrEqualTo	@selector(isGreaterThanOrEqualTo:)
#define BDQualifierOperatorContains		@selector(doesContain:)
#define BDQualifierOperatorLike			@selector(isLike:)
#define BDQualifierOperatorCaseInsensitiveLike	@selector(isCaseInsensitiveLike:)
#define BDQualifierOperatorContainsString		@selector(containsString:)
#define BDQualifierOperatorContainsCaseInsensitiveString @selector(containsCaseInsensitiveString:)
#define BDQualifierOperatorIn           @selector(isIn:)

extern NSString *BDQualifierVariableSubstitutionException;


@protocol BDQualifierEvaluation
- (BOOL)evaluateWithObject:(id)object;
@end


@interface BDQualifier : NSObject <NSCopying>
{
}

- (id)init;
- (void)dealloc;

+ (BDQualifier *)qualifierWithQualifierFormat:(NSString *)qualifierFormat, ...;

+ (BDQualifier *)qualifierWithQualifierFormat:(NSString *)qualifierFormat bindings: (NSDictionary*)bindings requiresAllVariables:(BOOL)requiresAll;
	// Takes the qualifier format and calls qualifierWithQualifierFormat: to get the qualifier, then calls qualifierWithBindings:requiresAllVarables: on the resulting qualifier.  Caveat:  You cannot use the arguments facility with this, all your value substitution must happen through the bindings!

+ (BDQualifier *)qualifierToMatchAllValues:(NSDictionary *)values;
+ (BDQualifier *)qualifierToMatchAnyValue:(NSDictionary *)values;
+ (BDQualifier *)qualifierToMatchAnyValue:(NSArray *)values andKey: (NSString*)key;

+ (BDQualifier *)qualifierFromLegacyPropertyList:(NSDictionary *)plist;

+ (BDQualifier *)qualifierWhereValueOfKey:(NSString *)aKey isEqualTo:(id)anObj;
+ (BDQualifier *)qualifierWhereValueOfKey:(NSString *)aKey isNotEqualTo:(id)anObj;

+ (BDQualifier *)qualifierWhereValueOfKey:(NSString *)aKey isLike:(id)anObj;
+ (BDQualifier *)qualifierWhereValueOfKey:(NSString *)aKey isNotLike:(id)anObj;


- (BDQualifier *)qualifierWithBindings:(NSDictionary *)bindings
                  requiresAllVariables:(BOOL)requiresAll;

- (BOOL)evaluateWithObject:(id)object;

- (unsigned)count;
- (NSArray *)subqualifiers;
- (void)addSubQualifier: (BDQualifier *)qualifier;
- (void)removeSubQualifier: (BDQualifier *)qualifier;
- (void)clearSubQualifiers;
- (void)replaceSubQualifiersWithQualifiers: (NSArray *)qualifiers;

+ (SEL)operatorSelectorForString:(NSString *)aString;
+ (NSString *)stringForOperatorSelector:(SEL)aSelector;

+ (NSArray *)allQualifierOperators;
+ (NSArray *)relationalQualifierOperators;

- (NSSet *)allQualifierKeys;
- (void)addQualifierKeysToSet:(NSMutableSet *)qualKeys;

- (NSArray *)bindingKeys;
- (NSString *)keyPathForBindingKey:(NSString *)key;

- (NSException *)validateKeysWithRootClassDescription:(NSClassDescription *)classDesc;

- (NSString *)formatValueBasedOnType:(id)value;

/* NSCopying Protocol */

- (id)copyWithZone:(NSZone *)zone;

@end


@interface NSArray (BDQualifierAdditions)
- (NSArray *)filteredArrayUsingQualifier:(BDQualifier *)qualifier;
@end
